# oneway_power2.R
# Power analysis for one-way ANOVA
# Load necessary libraries
library(ggplot2)

# H1 means, sample sizes, standard deviation, alpha
groupmeans <- c(20,22,22,25,18)
nvals <- 2:20
stddev <- 3
alpha <- 0.05

# Power analysis
powout1 <- power.anova.test(groups = length(groupmeans),n=nvals,
between.var=var(groupmeans),within.var=stddev^2,sig.level=alpha)
powout1

# New standard deviation and alpha
stddev <- 3
alpha <- 0.01

# Power analysis
powout2 <- power.anova.test(groups = length(groupmeans),n=nvals,
between.var=var(groupmeans),within.var=stddev^2,sig.level=alpha)
powout2

# New standard deviation and alpha
stddev <- 6
alpha <- 0.05

# Power analysis
powout3 <- power.anova.test(groups = length(groupmeans),n=nvals,
between.var=var(groupmeans),within.var=stddev^2,sig.level=alpha)
powout3

# New standard deviation and alpha
stddev <- 6
alpha <- 0.01

# Power analysis
powout4 <- power.anova.test(groups = length(groupmeans),n=nvals,
between.var=var(groupmeans),within.var=stddev^2,sig.level=alpha)
powout4

# Make data frame from power output
n <- powout1$n
power1 <- powout1$power
power2 <- powout2$power
power3 <- powout3$power
power4 <- powout4$power
powdata <- as.data.frame(cbind(n,power1,power2,power3,power4))

# Print data
powdata

# Plot power vs. sample size
ggplot(powdata,aes(n,power1))+
geom_line(color="black",size=1)+
geom_point(size=4,shape=1)+
geom_line(aes(n,power2),color="black",size=1,linetype="dashed")+
geom_point(aes(n,power2),color="black",size=4,shape=1)+
geom_line(aes(n,power3),color="black",size=1)+
geom_point(aes(n,power3),color="black",size=4,shape=3)+
geom_line(aes(n,power4),color="black",size=1,linetype="dashed")+
geom_point(aes(n,power4),color="black",size=4,shape=3)+
ggtitle("Power for one-way ANOVA")

